/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.Collection;
import java.util.List;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPotions;
import lotr.common.item.LOTRItemGraalMithril;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class LOTRItemGraal
extends Item {
    protected int maxDrinks = 2;

    public LOTRItemGraal() {
        this.func_77637_a(LOTRCreativeTabs.tabMisc);
        this.func_77625_d(1);
    }

    public static String strengthCalc(float input) {
        if (input == 0.25f) {
            return " (weak)";
        }
        if (input == 0.5f) {
            return " (light)";
        }
        if (input == 1.0f) {
            return " (moderate)";
        }
        if (input == 2.0f) {
            return " (strong)";
        }
        if (input == 3.0f) {
            return " (potent)";
        }
        return "";
    }

    private boolean canPlayerDrink(EntityPlayer entityplayer, ItemStack itemstack) {
        return itemstack.func_77942_o() && itemstack.func_77978_p().func_74762_e("hasDrink") > 0;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.drink;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 32;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (this.canPlayerDrink(entityplayer, itemstack)) {
            entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return itemstack;
    }

    public int getMaxDrinks() {
        return this.maxDrinks;
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        NBTTagCompound tagCompound;
        int hasDrink;
        if (!world.field_72995_K && itemstack.func_77942_o() && (hasDrink = (tagCompound = itemstack.func_77978_p()).func_74762_e("hasDrink")) > 0) {
            LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.useGraal);
            if (hasDrink == 1) {
                float strength1 = tagCompound.func_74760_g("strength1");
                this.applyPotionEffects(entityplayer, tagCompound.func_74779_i("potion1"), strength1);
                tagCompound.func_74768_a("hasDrink", 0);
                entityplayer.func_71024_bL().func_75122_a(3, 6.0f);
            } else if (hasDrink > 1) {
                if (entityplayer.func_70093_af()) {
                    for (int i = 1; i <= hasDrink; ++i) {
                        float strength = tagCompound.func_74760_g("strength" + i);
                        this.applyPotionEffects(entityplayer, tagCompound.func_74779_i("potion" + i), strength);
                    }
                    tagCompound.func_74768_a("hasDrink", 0);
                    entityplayer.func_71024_bL().func_75122_a(3, 6.0f);
                } else {
                    int currentDrink = hasDrink;
                    float strength = tagCompound.func_74760_g("strength" + currentDrink);
                    this.applyPotionEffects(entityplayer, tagCompound.func_74779_i("potion" + currentDrink), strength);
                    tagCompound.func_74768_a("hasDrink", currentDrink - 1);
                    entityplayer.func_71024_bL().func_75122_a(3, 6.0f);
                }
            }
            itemstack.func_77982_d(tagCompound);
        }
        return super.func_77654_b(itemstack, world, entityplayer);
    }

    private void restoreHunger(EntityPlayer entityplayer) {
        entityplayer.func_71024_bL().func_75122_a(3, 6.0f);
    }

    public ItemStack addDrinkToGraal(ItemStack itemstack, String potionKey, float strength) {
        NBTTagCompound tagCompound;
        int hasDrink;
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        if ((hasDrink = (tagCompound = itemstack.func_77978_p()).func_74762_e("hasDrink")) < this.maxDrinks) {
            tagCompound.func_74768_a("hasDrink", ++hasDrink);
            tagCompound.func_74778_a("potion" + hasDrink, potionKey);
            tagCompound.func_74776_a("strength" + hasDrink, strength);
        }
        itemstack.func_77982_d(tagCompound);
        return itemstack;
    }

    public String func_77653_i(ItemStack itemstack) {
        String baseName = super.func_77653_i(itemstack);
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74762_e("hasDrink") > 0) {
            return baseName + " " + StatCollector.func_74838_a((String)"item.lotr.graal.filled");
        }
        return baseName;
    }

    private void applyPotionEffects(EntityPlayer entityplayer, String potionKey, float strength) {
        if (potionKey.contains("AthelasBrew")) {
            this.combinePotionEffect(entityplayer, Potion.field_76428_l, (int)(500.0f * strength), 0);
            this.combinePotionEffect(entityplayer, Potion.field_76420_g, (int)(1600.0f * strength), 0);
        } else if (potionKey.contains("mugDwarvenTonic")) {
            this.combinePotionEffect(entityplayer, Potion.field_76439_r, (int)(4800.0f * strength), 0);
        } else if (potionKey.contains("mugRedDwarvenTonic")) {
            this.combinePotionEffect(entityplayer, Potion.field_76422_e, (int)(1200.0f * strength), 1);
        } else if (potionKey.contains("mugBlueDwarvenTonic")) {
            this.combinePotionEffect(entityplayer, Potion.field_76426_n, (int)(600.0f * strength), 0);
        } else if (potionKey.contains("UrukDraught")) {
            this.combinePotionEffect(entityplayer, Potion.field_76420_g, (int)(800.0f * strength), 0);
            this.combinePotionEffect(entityplayer, Potion.field_76429_m, (int)(300.0f * strength), 0);
            entityplayer.func_70097_a(DamageSource.field_76376_m, 2.0f * strength);
        } else if (potionKey.contains("KhamBrew")) {
            this.combinePotionEffect(entityplayer, LOTRPotions.frostResistance, (int)(1200.0f * strength), 0);
        } else if (potionKey.contains("ValinorBrew")) {
            this.combinePotionEffect(entityplayer, Potion.field_76428_l, (int)(1200.0f * strength), 0);
            this.combinePotionEffect(entityplayer, Potion.field_76429_m, (int)(2400.0f * strength), 0);
            this.combinePotionEffect(entityplayer, Potion.field_76426_n, (int)(2400.0f * strength), 0);
            this.combinePotionEffect(entityplayer, LOTRPotions.luck, (int)(800.0f * strength), 0);
        } else if (potionKey.contains("Miruvor")) {
            this.combinePotionEffect(entityplayer, Potion.field_76424_c, (int)(800.0f * strength), 0);
            this.combinePotionEffect(entityplayer, Potion.field_76420_g, (int)(800.0f * strength), 0);
        } else if (potionKey.contains("MorgulDraught")) {
            this.combinePotionEffect(entityplayer, Potion.field_76439_r, (int)(6000.0f * strength), 0);
        } else if (potionKey.contains("OrcDraught")) {
            this.combinePotionEffect(entityplayer, Potion.field_76424_c, (int)(1200.0f * strength), 0);
            this.combinePotionEffect(entityplayer, Potion.field_76420_g, (int)(1200.0f * strength), 0);
            entityplayer.func_70097_a(DamageSource.field_76376_m, 2.0f * strength);
        } else if (potionKey.contains("TauredainCocoa")) {
            this.combinePotionEffect(entityplayer, Potion.field_76420_g, (int)(800.0f * strength), 0);
            this.combinePotionEffect(entityplayer, Potion.field_76424_c, (int)(800.0f * strength), 0);
        } else if (potionKey.contains("TorogDraught")) {
            this.combinePotionEffect(entityplayer, Potion.field_76420_g, (int)(1800.0f * strength), 0);
        }
    }

    private void combinePotionEffect(EntityPlayer entityplayer, Potion potion, int duration, int amplifier) {
        Collection activeEffects = entityplayer.func_70651_bq();
        int totalDuration = duration;
        int maxAmplifier = amplifier;
        for (PotionEffect effect : activeEffects) {
            if (effect.func_76456_a() != potion.field_76415_H) continue;
            totalDuration += effect.func_76459_b();
            if (this instanceof LOTRItemGraalMithril) {
                maxAmplifier = Math.max(maxAmplifier, effect.func_76458_c() + 1);
                continue;
            }
            maxAmplifier = Math.max(maxAmplifier, effect.func_76458_c());
        }
        int finalAmplifier = Math.min(maxAmplifier, 1);
        entityplayer.func_82170_o(potion.field_76415_H);
        entityplayer.func_70690_d(new PotionEffect(potion.field_76415_H, totalDuration, finalAmplifier));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        super.func_77624_a(stack, player, list, advanced);
        if (!stack.func_77942_o() || stack.func_77978_p().func_74762_e("hasDrink") == 0) {
            list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"item.lotr.graal.empty"));
        } else {
            int hasDrink = stack.func_77978_p().func_74762_e("hasDrink");
            for (int i = 1; i <= hasDrink; ++i) {
                this.addLocalizedDrinkInfo(stack.func_77978_p().func_74779_i("potion" + i), stack.func_77978_p().func_74760_g("strength" + i), list);
            }
        }
    }

    private EnumChatFormatting getDrinkColor(String potionKey) {
        if (potionKey.contains("AthelasBrew")) {
            return EnumChatFormatting.GREEN;
        }
        if (potionKey.contains("DwarvenTonic")) {
            return EnumChatFormatting.BLUE;
        }
        if (potionKey.contains("RedDwarvenTonic")) {
            return EnumChatFormatting.DARK_PURPLE;
        }
        if (potionKey.contains("BlueDwarvenTonic")) {
            return EnumChatFormatting.LIGHT_PURPLE;
        }
        if (potionKey.contains("UrukDraught")) {
            return EnumChatFormatting.DARK_GRAY;
        }
        if (potionKey.contains("KhamBrew")) {
            return EnumChatFormatting.GOLD;
        }
        if (potionKey.contains("Miruvor")) {
            return EnumChatFormatting.YELLOW;
        }
        if (potionKey.contains("MorgulDraught")) {
            return EnumChatFormatting.DARK_GREEN;
        }
        if (potionKey.contains("OrcDraught")) {
            return EnumChatFormatting.RED;
        }
        if (potionKey.contains("TauredainCocoa")) {
            return EnumChatFormatting.DARK_RED;
        }
        if (potionKey.contains("TorogDraught")) {
            return EnumChatFormatting.GOLD;
        }
        return EnumChatFormatting.GRAY;
    }

    private EnumChatFormatting getStrengthColor(int index) {
        switch (index) {
            case 0: {
                return EnumChatFormatting.GREEN;
            }
            case 1: {
                return EnumChatFormatting.YELLOW;
            }
            case 2: {
                return EnumChatFormatting.GOLD;
            }
            case 3: {
                return EnumChatFormatting.RED;
            }
            case 4: {
                return EnumChatFormatting.DARK_RED;
            }
        }
        return EnumChatFormatting.WHITE;
    }

    private String getLocalizedStrength(float strength) {
        if (strength == 0.25f) {
            return StatCollector.func_74838_a((String)"item.lotr.drink.weak");
        }
        if (strength == 0.5f) {
            return StatCollector.func_74838_a((String)"item.lotr.drink.light");
        }
        if (strength == 1.0f) {
            return StatCollector.func_74838_a((String)"item.lotr.drink.moderate");
        }
        if (strength == 2.0f) {
            return StatCollector.func_74838_a((String)"item.lotr.drink.strong");
        }
        if (strength == 3.0f) {
            return StatCollector.func_74838_a((String)"item.lotr.drink.potent");
        }
        return "";
    }

    private void addLocalizedDrinkInfo(String potionKey, float strength, List list) {
        String localizedPotionName = StatCollector.func_74838_a((String)(potionKey + ".name"));
        int strengthIndex = this.getStrengthIndex(strength);
        EnumChatFormatting typeColor = this.getDrinkColor(potionKey);
        EnumChatFormatting strengthColor = this.getStrengthColor(strengthIndex);
        String strengthLocalized = this.getLocalizedStrength(strength);
        list.add(typeColor + localizedPotionName + EnumChatFormatting.GRAY + " (" + strengthColor + strengthLocalized + EnumChatFormatting.GRAY + ")");
    }

    private int getStrengthIndex(float strength) {
        if (strength >= 3.0f) {
            return 4;
        }
        if (strength >= 2.0f) {
            return 3;
        }
        if (strength >= 1.0f) {
            return 2;
        }
        if (strength >= 0.5f) {
            return 1;
        }
        return 0;
    }

    public static boolean isItemFullDrink(ItemStack itemstack) {
        if (itemstack == null || !itemstack.func_77942_o()) {
            return false;
        }
        int hasDrink = itemstack.func_77978_p().func_74762_e("hasDrink");
        return hasDrink > 0;
    }
}

